clear all
%Model preliminaries 
ngrid=501;
c_upper1=zeros(1,ngrid);
c_upper2=zeros(1,ngrid);
c_upper3=zeros(1,ngrid);
c_lower_g1=zeros(1,ngrid);
c_lower_g2=zeros(1,ngrid);
c_lower_g3=zeros(1,ngrid);
Delta=0.2; 
P=1.20;
gamma=1.2; 
omega=0.0001;
%Additional parameters 
omega_g=8e-7;
c_g=0.01;

%%
%The guarantor economy across credit cycles: changing Rd
Rd1=1.06;
Rd2=1.04;
Rd3=1.02;

%Solve phi_star 
pi_fun=@(x)(x-(1+1/gamma)*(omega*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega-Rd1);
phi_grid=linspace(0,5,ngrid);
pi_grid=zeros(1,ngrid);
x=linspace(0,1,ngrid);
for i=1:ngrid
    pi_grid(i)=pi_fun(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_star1=phi_grid(index); 

pi_fun=@(x)(x-(1+1/gamma)*(omega*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega-Rd2);
for i=1:ngrid
    pi_grid(i)=pi_fun(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_star2=phi_grid(index);

pi_fun=@(x)(x-(1+1/gamma)*(omega*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega-Rd3);
for i=1:ngrid
    pi_grid(i)=pi_fun(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_star3=phi_grid(index);

%Solve phi_g_star
pi_fun_g=@(x)(x-(1+1/gamma)*(omega_g*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega_g-c_g);
for i=1:ngrid
    pi_grid(i)=pi_fun_g(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_g_star=phi_grid(index);
phi_g_star

%Check Assumption 1 
if phi_g_star+Rd1 > phi_star1 
    error('Assumption 2 violated: c_g too high for Rd=1.06')
end 

if phi_g_star+Rd2 > phi_star2 
    error('Assumption 2 violated: c_g too high for Rd=1.04')
end 

if phi_g_star+Rd3 > phi_star3 
    error('Assumption 2 violated: c_g too high for Rd=1.02')
end 

for i=1:ngrid
  
    if x(i)<Delta 
        xhat=0.5*(x(i)+Delta);
    elseif x(i)>1-Delta 
        xhat=0.5*(1+x(i)-Delta); 
    else 
        xhat=x(i);
    end 
    
    c_upper1(i)=max((Rd1-P*(1-xhat))/xhat,0);
    c_upper2(i)=max((Rd2-P*(1-xhat))/xhat,0);
    c_upper3(i)=max((Rd3-P*(1-xhat))/xhat,0);    
    xhhat=max(x(i)-Delta,0);
    c_lower_g1(i)=max((Rd1+phi_g_star-P*(1-xhhat))/xhhat,0);
    c_lower_g2(i)=max((Rd2+phi_g_star-P*(1-xhhat))/xhhat,0);
    c_lower_g3(i)=max((Rd3+phi_g_star-P*(1-xhhat))/xhhat,0);    
    
end 


%%
sky_blue = [135 206 250]./255;
light_grey = [211 211 211]./255;
light_pink = [255 192 203]./255;

figure 
h1 = plot(x,c_upper2,'k-', 'LineWidth', 1.5);
hold on;
h2 = plot(x,c_upper3,'k-.', 'LineWidth', 1.5);
hold on;
h3 = plot(x,c_lower_g2,'r--', 'LineWidth', 1.5);
hold on 
h4 = plot(x,c_lower_g3,'r:', 'LineWidth', 1.5);
xlabel('Balance sheet signal x', 'FontSize', 14)
ylabel('Collateral c', 'FontSize', 14)
title('', 'Interpreter', 'latex', 'FontSize', 14)


xxx2=x(c_upper2>c_lower_g2);  yyy_up2 = c_upper2(c_upper2>c_lower_g2); yyy_down2 = c_lower_g2(c_upper2>c_lower_g2);
h5 = fill([xxx2, fliplr(xxx2)], [yyy_up2,  fliplr(yyy_down2)], sky_blue, 'EdgeColor', 'none'); hold on; alpha(0.4);

xxx3=x(c_upper3>c_lower_g3);  yyy_up3 = c_upper3(c_upper3>c_lower_g3); yyy_down3 = c_lower_g3(c_upper3>c_lower_g3);
h6 = fill([xxx3, fliplr(xxx3)], [yyy_up3,  fliplr(yyy_down3)], light_grey, 'EdgeColor', 'none'); hold on; alpha(0.4);

legend([h1 h2 h3 h4 h5 h6], '$\bar{c}: R^d=1.04$','$\bar{c}: R^d=1.02$','$\underline{c}_g: R^d=1.04$','$\underline{c}_g: R^d=1.02$',...
    'Projects funded when $R^d=1.04$', ...
    'Projects funded when $R^d=1.02$', 'Interpreter','latex','Location','southeast', 'FontSize', 14);
%set(h,'Interpreter','latex','Location','southwest')

set(gcf, 'Position', [10 10 800 600]);
saveas(gcf, './credit_cycle.eps', 'epsc')





